=begin
=基盤システム/メモ欄読み込み




==更新履歴
  Date     Version Author Comment
==14/12/13 2.0.0   トリス 統合A～E A

=end

#==============================================================================
# ■ RPG::BaseItem
#==============================================================================
class RPG::BaseItem
  #--------------------------------------------------------------------------
  # ● Mix-In
  #--------------------------------------------------------------------------
  include       NWFeature
  include       NWFeature::Flag
  include       NWFeature::Party
  include       NWFeature::PartyEx
  include       NWFeature::Battler
  include       NWFeature::Booster  
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    @data_ex = {}
    @add_features = []
    note.each_line do |line|
      nw_line_analyze(line)
    end
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    @features + @add_features
  end
  #--------------------------------------------------------------------------
  # ● 特徴配列（基本）
  #--------------------------------------------------------------------------  
  def basic_features
    return @features
  end
end

#==============================================================================
# ■ RPG::Class::Learning
#==============================================================================
class RPG::Class::Learning
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
  end
end

#==============================================================================
# ■ RPG::Map
#==============================================================================
class RPG::Map
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    @data_ex = {}
    note.each_line do |line|
      nw_line_analyze(line)
    end
  end
end

#==============================================================================
# ■ RPG::Tileset
#==============================================================================
class RPG::Tileset
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
  end
end

#==============================================================================
# ■ RPG::UsableItem
#==============================================================================
class RPG::UsableItem < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    @effects_ex = []
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end  
end

#==============================================================================
# ■ RPG::EquipItem
#==============================================================================
class RPG::EquipItem < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::Class
#==============================================================================
class RPG::Class < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::Actor
#==============================================================================
class RPG::Actor < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::Enemy
#==============================================================================
class RPG::Enemy < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::State
#==============================================================================
class RPG::State < RPG::BaseItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::Skill
#==============================================================================
class RPG::Skill < RPG::UsableItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
  #--------------------------------------------------------------------------
  # ○ 連続回数
  #--------------------------------------------------------------------------  
  def repeats
    super
  end
  #--------------------------------------------------------------------------
  # ○ 使用効果
  #--------------------------------------------------------------------------  
  def effects
    super
  end
end

#==============================================================================
# ■ RPG::Item
#==============================================================================
class RPG::Item < RPG::UsableItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
  #--------------------------------------------------------------------------
  # ○ 連続回数
  #--------------------------------------------------------------------------  
  def repeats
    super
  end
  #--------------------------------------------------------------------------
  # ○ 使用効果
  #--------------------------------------------------------------------------  
  def effects
    super
  end
end

#==============================================================================
# ■ RPG::Weapon
#==============================================================================
class RPG::Weapon < RPG::EquipItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

#==============================================================================
# ■ RPG::Armor
#==============================================================================
class RPG::Armor < RPG::EquipItem
  #==============================================================================
  # ● メモ欄解析処理
  #==============================================================================
  def nw_note_analyze
    super
  end
  #--------------------------------------------------------------------------
  # ○ 特徴配列
  #--------------------------------------------------------------------------  
  def features
    super
  end
end

